# Colorful (Simplified) for EmulationStation <br>*(Batocera, RetroBat &amp; JELOS)*

This is simplified take on the Colorful theme which was originally created by [viking](https://forums.launchbox-app.com/profile/70421-viking/) & [faeran](https://forums.launchbox-app.com/profile/76940-faeran/) for Launchbox.

Most artwork was originally created by viking (_additional artwork credits can be found in the credits section below_). I translated things for the theming engine used by Batocera. The original version of the Colorful theme for Launchbox can be found [here](https://forums.launchbox-app.com/files/file/2081-colorful-bigbox-theme)

### Changes Made

- Translated and rewrote all Launchbox specific aspects to make the theme compatible with Batocera, RetroBat &amp; JELOS
- Updated system image names to match the standard used by Batocera, RetroBat &amp; JELOS
- Created images & color schemes for additional systems supported by Batocera, RetroBat &amp; JELOS
- Embedded the ES-DE [system-metadata](https://gitlab.com/es-de/themes/system-metadata) repository to power system description, release year and color details

## **Preview**

| System View |
|----|
| ![screenshot-2024 02 16-19h12 50](https://github.com/anthonycaccese/colorful-simplified-es/assets/1454947/baff46bf-4097-4a5c-996d-543b83812aac) |

| Gamelist View: Metadata Off | Gamelist View: Metadata On |
|----|----|
| ![screenshot-2024 02 16-19h18 53](https://github.com/anthonycaccese/colorful-simplified-es/assets/1454947/f2a80f4f-b358-403e-ad7d-db29aa579cc9) | ![screenshot-2024 02 16-19h24 22](https://github.com/anthonycaccese/colorful-simplified-es/assets/1454947/6bc5987d-f2eb-48c2-8f53-831ac745e83b) |

## **Configuration Options**

The theme has a simple set of options that can be changed directly from the `User Interface Settings > Theme Configuration` menu in EmulationStation

### **Gamelist View Style**

- `Gamelist View Style` - sets the layout used for the gamelist view when media & metadata are scraped for your games.
   - `Metadata Off` - Displays just a gamelist and game artwork
   - `Metadata On` - Displays all available metadata for a game along with its artwork

### **Color Scheme**

- `Color Scheme` - sets the color scheme that is used for the overall theme on all views.  There are 6 built in color schems:
   - `Colorful` - The default color scheme.  Displays a custom color for each system based on the Colorful media set.
   - `Light` - Sets a light color scheme that displays for all systems
   - `RetroBright` - Sets a light color scheme that displays for all systems
   - `DMG` - Sets a light color scheme that displays for all systems
   - `Dark` - Sets a dark color scheme that displays for all systems
   - `OLED` - Sets a dark color scheme that displays for all systems

#### Preview

| Colorful | Light |
|:---:|:---:|
| ![Screenshot 2024-02-07 at 4 45 20 PM](https://github.com/anthonycaccese/colorful-simplified-es-de/assets/1454947/91f2c968-dadb-4ae1-8197-250a54785f0b) | ![Screenshot 2024-02-07 at 4 48 29 PM](https://github.com/anthonycaccese/colorful-simplified-es-de/assets/1454947/ebca482e-73c2-475e-a830-3161d5315380) |
| RetroBright | DMG |
| ![Screenshot 2024-02-07 at 4 48 36 PM](https://github.com/anthonycaccese/colorful-simplified-es-de/assets/1454947/5e7f7cbd-0feb-497e-b27d-8ba0a72181d0) | ![Screenshot 2024-02-07 at 4 48 43 PM](https://github.com/anthonycaccese/colorful-simplified-es-de/assets/1454947/107ac980-b3a4-455f-b0d4-9d31c9a8e9cb) |
| Dark | OLED |
| ![Screenshot 2024-02-07 at 4 48 49 PM](https://github.com/anthonycaccese/colorful-simplified-es-de/assets/1454947/b35defdf-3b37-4aa3-b741-2e1a0813fe90) | ![Screenshot 2024-02-07 at 4 48 56 PM](https://github.com/anthonycaccese/colorful-simplified-es-de/assets/1454947/e4c5e9ca-248a-4898-a783-13f0f8a10d1f) |

### **Font Size**

- `Font Size` - sets the size that text will render at. This can be helpful when using the theme on small screens.
   - Supported Font Sizes:
   - `Medium` - Default size, good for computer monitors and tvs.
   - `Large` - Larger size, good for small handheld screens under 6 inches in size.

### **Aspect Ratio**

- `Aspect Ratio` - sets the aspect ratio to match your display. This should happen automatically but can also be set manually if needed.
   - Supported Aspect Ratios:
   - `16:9`
 
## **Addons**

- `System View Video` (720p)
   - Adds an option to turn on/off the display of videos in the system view
   - Videos are sourced from the Coloful video set by [viking](https://forums.launchbox-app.com/profile/70421-viking/) and others in the Launchbox community
   - Download & Instructions are here: https://github.com/anthonycaccese/colorful-simplified-es-addons-video-720

## Additional Notes

### Versions for other ES forks:
* If you use ES-DE... then check out the version [here](https://github.com/anthonycaccese/colorful-simplified-es-de).  The ES-DE version has most of the same base features.  It also adds some additional features such as a carousel view.

### Credits/Sources

- Most artwork originally created by [viking](https://forums.launchbox-app.com/profile/70421-viking/) & [faeran](https://forums.launchbox-app.com/files/file/2081-colorful-bigbox-theme)
- For systems that did not exist in the Colorful set; some were sourced from the great work done by [g-spawn](https://github.com/g-spawnPL) for the [ckau-book](https://github.com/CkauNui/ckau-book/tree/master) theme and they were edited to add transparency.
- OpenBOR sprites originally created by [DOA687](https://www.deviantart.com/doa687)
- M.U.G.E.N. sprites originally created by [mpadillathespriter](https://www.deviantart.com/mpadillathespriter)
- EasyRPG artwork originally created by [SeraphCircle](https://twitter.com/SeraphCircle)
- Doom artwork originally created by [azakachi-rd-17](https://www.deviantart.com/azakachi-rd-17)
- Quake artwork by [noorkabir](https://imgbin.com/png/TpRDSTtK/quake-champions-quake-iii-arena-quake-4-video-game-2017-dreamhack-winter-png)
- LowresNX artwork by [Duimon](https://forums.libretro.com/t/duimon-hsm-mega-bezel-graphics-and-presets-feedback-and-updates/28146/1049)
- The base folder image used to create the All Games, Favorites, Last Played and Custom Collections images was sourced from [Rick Patrick](https://www.softicons.com/designers/rick-patrick).
- The icons on the folder images were sourced from [FontAwesome](https://fontawesome.com/search?o=r&m=free)

## **License**

Creative Commons CC-BY-NC-SA - https://creativecommons.org/licenses/by-nc-sa/2.0/
You are free to share and adapt this theme as long as you provide attribution back as well share any updates you make under the same licence terms.
