# How to install
Playstation-X theme is integrated into the official download manager of Batocera-EmulationStation, and you can download it from your favorite frontend (Batocera, Retrobat, EmuElec, etc...). To do so, go to 
"MAIN MENU -> UPDATES & DOWNLOADS -> THEMES -> Playstation-X". 
It's that simple.

## Manual Installation
Download the Zip file from GitHub repository, unzip and copy its contents into the "/userdata/themes/" or "/share/themes/" folder. 

# PlayStation-X Retrogaming theme


![](https://es-theme-playstation-x.tocapixels.com/41/00.jpg)

A PlayStation-inspired theme that brings the look and feel of the PS3, PS4, and PS5 interfaces, with custom avatars, usernames, RetroAchievements support, and much more for Batocera, RetroBat, and EmuElec (Or any frontend using the Batocera EmulationStation fork)

We hope you enjoy it! Your feedback is always welcome, and if you like the theme, don’t forget to give it a ⭐ on GitHub to help others discover it!

|                                    |                                    |
| :--------------------------------: | :--------------------------------: |
| ![](https://es-theme-playstation-x.tocapixels.com/41/01.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/04.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/42/01.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/42/02.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/42/05.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/42/04.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/05.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/06.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/07.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/08.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/09.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/10.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/11.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/12.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/13.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/14.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/15.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/16.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/17.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/42/03.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/19.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/20.jpg) |
| ![](https://es-theme-playstation-x.tocapixels.com/41/21.jpg) | ![](https://es-theme-playstation-x.tocapixels.com/41/22.jpg) |


[![Playstation X Config guide](https://es-theme-playstation-x.tocapixels.com/thumbvideo/psx-video-guide.jpg)](https://www.youtube.com/watch?v=6xfdHXLDhWs)

## Important notice to the theme Version 39 and next
**Warning:** Due to substantial changes in the source code of Batocera EmulationStation regarding theme building, the theme version 39 is only compatible with Batocera 39 or RetroBat 6 and next versions. If you encounter issues, please update your frontend or downgrade to an earlier version of the theme.

https://github.com/pajarorrojo/es-theme-PlayStation-X/releases/tag/Previous-releases


## An improved game lists enviroment!

Since version 37 the game list combines the following theme options: 6 view types (detailed, grid, horizontal carousel, ps4Style carousel, full grid and Game by game), all scraped image formats for both the main position and within the grid (image, thumbnail, marquee, fanart, boxart, boxback, cartridge, and titleshot, or none), 5 ways to display game videos (window, background video, within the grid, and overlay, or none), background fanart, and the ability to hide or show game descriptions and extra information. And of course, all adapted to the screen aspect ratios already supported by the theme.

[![Playstation X 37 Re-viewed (All Views)](https://es-theme-playstation-x.tocapixels.com/thumbvideo/thumb-01.jpg)](https://www.youtube.com/watch?v=cbo0sx8Mk3Eb)

One system, one layout!
The select button is your friend...

You can customize each system with a completely personalized view. Simply press the select button on your controller (or compatible key) while in a game list to access the specific gamelist settings. From here, you can change the list type (detailed, grid, carousel etc.) and configure it with many custom theme options, such as displaying any type of scraped image or simply hiding it. You can also hide game descriptions or extra information, enable video modes, grid animations, background fanart, etc. Let your imagination run wild, now you have dozens of combinations that will make your environment truly dynamic, fresh and different.

|                                    |                                    |                                    |
| :--------------------------------: | :--------------------------------: | :--------------------------------: |
| [![(ps4 Style Carousel Custom)](https://es-theme-playstation-x.tocapixels.com/thumbvideo/thumb-03.jpg)](https://www.youtube.com/watch?v=gmeItHffFYA) | [![(Full Grid Custom)](https://es-theme-playstation-x.tocapixels.com/thumbvideo/thumb-04.jpg)](https://www.youtube.com/watch?v=s2DZsqBRSVg) | [![(Horizontal Carousel Custom)](https://es-theme-playstation-x.tocapixels.com/thumbvideo/thumb-05.jpg)](https://www.youtube.com/watch?v=ZiAk7QotviA) |

Alongside all this, a new utility has been added, a game list called "Game Media Tester." By activating this list, you can quickly check the Batocera-compatible media assigned to each game in a very clear way.


[![(Game Media Tester View)](https://es-theme-playstation-x.tocapixels.com/thumbvideo/thumb-06.jpg)](https://www.youtube.com/watch?v=OxoLxIAK5hs) 

I hope you enjoy the theme! Hard work has been done to improve the user experience and offer more customization options for gamelist. I invite you to try all the possible combinations and discover how you can create a dynamic environment tailored to your preferences.

Have fun with retro gaming!



### COMPATIBLE WITH MULTIPLE SCREEN ASPECT RATIOS

Theme Compatible with common used aspect ratios including tiny screens, the theme automatically fits to the next compatible screen resolutions: 
- 4:3 
- 16:9 
- 16:10
- 21:9
- 3:2
- 5:3
- 5:4 

NOTE: The automatic fit is only compatible with batocera 35 or higher, if you use an older version of batocera, don't forget to manually select your correct aspect ratio in theme settings to avoid display issues.



### AVAILABLE IN 15 LANGUAGES

- English (EN) (default for not supported or untranslated languages)
- Español (ES)
- Català (CA)
- Euskara (EU)
- Galego (GL)
- Français (FR)
- Português (PT)
- Italiano (IT)
- Deutsch (DE)
- Polski (PL)
- Русский (RU)
- عربي (AR)
- עִברִית (HE)
- 简体中文 (ZH)
- 日本語 (JA)


Any collaboration for translation or new language supported is fully appreciated



### ADAPTED TO NETPLAY AND RETROACHIEVEMENTS
You can find at the top of the theme the icons that indicate the compatibility of systems or games at a glance:


[![Playstation X social icons](https://es-theme-playstation-x.tocapixels.com/img/netplay-ra-table-thumb.png)](https://es-theme-playstation-x.tocapixels.com/img/netplay-ra-table.png)



### HOW TO CHANGE AVATAR AND USERNAME

Playstation-x is ready to display your Netplay or Retroachievements username, you can select it in the theme options.


[![Playstation X (Change Username and Avatar)](https://es-theme-playstation-x.tocapixels.com/thumbvideo/thumb-02.jpg)](https://www.youtube.com/watch?v=bUSrc7yhSGk)

You can also use a fully customized username and image, for this you will find two files in the theme root folder.

- To change the avatar image simply overwrite the PNG file named "custom-avatar.png" (work best with square format)

- To change the username string, open the file "custom-username.xml" with a text editor and change "username" for the desired nick

- To apply don't forget to set in theme options "Choose a nick -> custom" and/or "Choose your avatar -> custom"



### HOW TO CUSTOMIZE THE SYSTEMS VIEW

Multiple options for the system view are available, background random fanart, snap videos or advertising videos, carousel size, background video or windowed video, etc:

[![Playstation X (How to config system view)](https://es-theme-playstation-x.tocapixels.com/thumbvideo/thumb-07.jpg)](https://www.youtube.com/watch?v=Q4Qw6KCCcQk)



### USING ANOTHER BACKGROUND MUSIC

If the chill audio that comes with the theme doesn't suit you, you can place your favorite music files in /_theme_music/ folder. (.ogg and .mp3 are allowed). 

You can also activate the default music tracks from batocera turning off the "play system-specific music" option under the batocera "sound settings" menu ;)



### ENABLE NAVIGATION SOUNDS

Playstation-X has specific navigation sounds to enrich the user experience. Batocera has this feature disabled by default. You can activate the navigation sounds in "Enable navigation sounds" option under the batocera sound menu.

--------------------------------

Thanks and credits:
-------
- Fabrice Caruso, for inspiring me with his awesome carbon theme for batocera, and for always updating and performing batocera-emulationstation. https://github.com/fabricecaruso
- Seis, for being the first person to recommend the theme for the batocera's official list https://github.com/seeiis
- Lio, for posting the theme on batocera's official list and making it known to the community : https://github.com/lbrpdx
- Snapouille and Soaresden, for helping with French translation https://github.com/Snapouille
- Janderson for helping with Portuguese translation https://github.com/JandersonJS
- TheDayG0ne and Vortex or helping with Russian translation https://github.com/TheDayG0ne
- CadmiumRED for helping with some test and medias https://github.com/CadmiumRED/
- renetrox87 for inspiration with the overlayed arts https://github.com/Renetrox/
- Nexusone and their indomitable ARRM scraping software, which I recommend to keep your media collections always up to date. (http://jujuvincebros.fr/telechargements2/file/10-arrm-another-recalbox-roms-manager)
- Zoidburg13 For its collection of icons, some of which are used in the PS3 carousel https://github.com/Zoidburg13
- To the entire batocera team, members and contributors, for making and incredible piece of software and a truly open community.

Some media files like system backgrounds, consoles or logos have been selected from the default Carbon theme

Youtube Channel:
https://www.youtube.com/@pajarorrojo/featured

Batocera discord:
https://discord.gg/mYREusrT

Batocera reddit:
https://www.reddit.com/r/batocera/

Batocera wiki:
https://wiki.batocera.org/


Notice:
-------
- All system logos, game artwork, screenshots and trademarks are copyright of their respective owners. 


Licence
-------
**Attribution-NonCommercial-ShareAlike 4.0 International (CC BY-NC-SA 4.0)**
https://creativecommons.org/licenses/by-nc-sa/4.0/

![Creative Commons Licence](https://i.creativecommons.org/l/by-nc-sa/4.0/88x31.png "Creative Commons Licence")

Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International Public License

You are free to:

- **Share:** copy and redistribute the material in any medium or format
- **Adapt:** remix, transform, and build upon the material

**Under the following terms:**

**Attribution:** You must give appropriate credit, provide a link to the license, and indicate if
changes were made. You may do so in any reasonable manner, but not in any way that suggests the
licensor endorses you or your use.

**NonCommercial:** You may not use the material for commercial purposes.

**ShareAlike:** If you remix, transform, or build upon the material, you must distribute your
contributions under the same license as the original.

No additional restrictions — You may not apply legal terms or technological measures that legally
restrict others from doing anything the license permits.
